CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
	MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
	IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_NAME= 'glb_layout_filipeta') THEN 
		CREATE TABLE public.glb_layout_filipeta
		(
			cd_emp integer NOT NULL,
			cd_filipeta integer NOT NULL,
			ds_filipeta character varying(50) ,
			cabecalho text null,
			rodape text null,
			CONSTRAINT glb_layout_filipeta_pkey PRIMARY KEY (cd_emp,cd_filipeta)
		)
		WITH (OIDS=FALSE);		
	ELSE    
		MSGFINAL := 'A TABELA JÁ EXISTE';
	END IF;

	RAISE NOTICE 'TABELA glb_layout_filipeta %', MSGFINAL::VARCHAR;

END; 
-- FIM BLOCO PRINCIPAL 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
  COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();
